# Aplikasi Peminjaman Barang (Flask)

Aplikasi web berbasis Python (Flask) untuk mengelola peminjaman peralatan siaran/produksi.
Fitur utama:
- Menu Admin: **History Peminjaman**, **Daftar Barang (CRUD)**, **Daftar User (CRUD)**, **Manajemen Pinjaman (persetujuan, tandai dipinjam, selesai)**
- Menu User: **Ajukan Pinjaman**, **Daftar Barang Ready**, **Pengembalian aktif hanya saat sedang meminjam**
- Upload foto: **foto saat pengajuan (opsional)**, **foto saat meminjam**, **foto saat pengembalian**

## Cara Menjalankan (Lokal)
1. Buat environment (opsional) lalu install dependensi:
   ```bash
   pip install -r requirements.txt
   ```
2. Inisialisasi database serta buat admin default:
   ```bash
   python app.py --initdb
   ```
   Admin default:
   - Email: `admin@local`
   - Password: `admin123`
   Ganti password setelah login.
3. Jalankan server dev:
   ```bash
   flask --app app run --debug
   ```
   atau:
   ```bash
   python app.py
   ```
4. Buka `http://127.0.0.1:5000`

## Struktur Status Peminjaman
- `requested` (Diajukan, menunggu persetujuan admin)
- `approved` (Disetujui admin, siap diambil)
- `borrowed` (Sedang dipinjam; foto peminjaman wajib)
- `completed` (Selesai dikembalikan; foto pengembalian wajib)

## Catatan
- Upload disimpan di folder `uploads/`.
- `Daftar Barang Ready` menghitung ketersediaan: **quantity - (approved + borrowed)**.
- Untuk kesederhanaan, ketersediaan belum memperhitungkan overlap tanggal.

## Akun & Peran
- `User` (default saat registrasi)
- `Admin` (akses menu admin). Hanya admin yang bisa menyetujui/menandai status pinjaman.

Selamat mencoba 🙌
