#!/usr/bin/env bash
set -euo pipefail

echo "===> Aplikasi Peminjaman - Setup untuk macOS (zsh/bash)"
echo "Lokasi: $(pwd)"

# 1) Buat venv bila belum ada
if [ ! -d "venv" ]; then
  echo "===> Membuat virtual environment (venv)"
  python3 -m venv venv
fi

# 2) Aktivasi venv
echo "===> Mengaktifkan venv"
# shellcheck disable=SC1091
source venv/bin/activate

# 3) Upgrade build tools
echo "===> Upgrade pip/setuptools/wheel"
python -m pip install --upgrade pip setuptools wheel

# 4) Install Pillow via wheel dulu (hindari compile dari source)
echo "===> Instalasi Pillow (wheel only, jika tersedia)"
python -m pip install --only-binary=:all: pillow || true

# 5) Install requirements project
echo "===> Instalasi requirements project"
python -m pip install -r requirements.txt

# 6) Inisialisasi DB & admin default
echo "===> Inisialisasi database & admin default"
python app.py --initdb

cat <<'INFO'

=============================================
Setup selesai 🎉

Admin default:
  email: admin@local
  password: admin123

Jalankan aplikasi:
  source venv/bin/activate
  python app.py

Buka di browser:
  http://127.0.0.1:5000

Catatan:
- Jika instalasi Pillow gagal karena tidak ada wheel dan pip mencoba compile dari source,
  pastikan Command Line Tools terpasang:
    xcode-select --install
  Lalu jalankan ulang script ini.
- Alternatif (opsional, jika ingin build dari source):
    brew install jpeg zlib freetype
=============================================
INFO
